# Manuel Utilisateur - Système de Gestion Intégré CDL

## 1. Introduction

Bienvenue dans le manuel utilisateur du Système de Gestion Intégré (SGI) du Centre Diagnostic Libreville (CDL). Ce document a pour but de vous guider dans l'utilisation de l'application, en fonction de votre rôle et de vos responsabilités.

## 2. Connexion

Pour accéder à l'application, rendez-vous sur la page de connexion et saisissez votre identifiant (ou votre adresse e-mail) et votre mot de passe.

-   **Visibilité du mot de passe** : Vous pouvez cliquer sur l'icône en forme d'œil (👁️) dans le champ du mot de passe pour afficher ou masquer les caractères que vous saisissez.
-   **Connexion persistante** : Une fois connecté, le système vous reconnaîtra lors de vos prochaines visites sur le même navigateur, vous n'aurez donc pas besoin de vous reconnecter à chaque fois.

## 3. Présentation de l'Interface

L'interface se compose de trois zones principales :

1.  **En-tête (Header)** : Situé en haut, il contient le logo, le nom de l'application, les informations sur l'utilisateur connecté, la cloche de notifications (🔔) et le bouton de déconnexion.
2.  **Menu de Navigation (Sidebar)** : Sur la gauche (ou accessible via le bouton "Menu" sur mobile), il vous permet de naviguer entre les différentes sections autorisées pour votre rôle.
3.  **Zone de Contenu Principal** : C'est ici que s'affichent les tableaux de bord, les formulaires et les listes correspondant à la section que vous avez sélectionnée.

## 4. Fonctionnalités par Rôle

### 4.1 Agent de Sécurité

-   **Tableau de bord Sécurité** : Vue d'ensemble des indicateurs clés liés à la sécurité.
-   **Signaler un Incident** : Formulaire pour déclarer un nouvel incident de sécurité (vol, intrusion, etc.).
-   **Liste des Incidents** : Tableau de tous les incidents de sécurité, avec leur statut et leur priorité.
-   **Registre des Visiteurs** : Permet d'enregistrer l'entrée et la sortie des visiteurs.
-   **Mes Tâches** : Liste des tâches planifiées qui vous ont été assignées par un superviseur.

### 4.2 Superviseur Agent de Sécurité

Le Superviseur Agent de Sécurité gère les activités de l'équipe de sécurité.

-   **Dashboard Sécurité** : Vue d'ensemble des indicateurs clés liés à la sécurité.
-   **Gestion Incidents** : Accès à la liste des incidents de sécurité, avec la possibilité de les assigner, de modifier leur priorité et leur statut.
-   **Signaler un Incident** : Formulaire pour déclarer un nouvel incident de sécurité.
-   **Registre des Visiteurs** : Permet d'enregistrer l'entrée et la sortie des visiteurs.
-   **Planning Tâches** : Création et assignation de tâches planifiées spécifiquement pour les agents de sécurité.
-   **Gestion Agents** : Gestion des comptes et des permissions des agents de sécurité.

### 4.3 Agent d'Entretien

-   **Tableau de bord Entretien** : Vue d'ensemble des tâches d'entretien.
-   **Signaler un Problème** : Formulaire pour signaler un problème de nettoyage, de sanitaire, etc.
-   **Mes Tâches Assignées** : Liste des tickets d'entretien qui vous sont assignés. Vous pouvez démarrer ou terminer une tâche depuis cette vue.
-   **Historique des Tâches** : Consultation de toutes vos tâches terminées.
-   **Mes Tâches (Planifiées)** : Liste des tâches récurrentes ou planifiées qui vous ont été assignées.

### 4.4 Superviseur Agent d'Entretien

Le Superviseur Agent d'Entretien gère les activités de l'équipe d'entretien.

-   **Dashboard Entretien** : Vue d'ensemble des tâches d'entretien.
-   **Gestion Tickets** : Accès à la liste des tickets d'entretien, avec la possibilité de les assigner, de modifier leur priorité et leur statut.
-   **Signaler un Problème** : Formulaire pour signaler un problème d'entretien.
-   **Historique Tâches** : Consultation de l'historique des tâches d'entretien.
-   **Planning Tâches** : Création et assignation de tâches planifiées spécifiquement pour les agents d'entretien.
-   **Gestion Agents** : Gestion des comptes et des permissions des agents d'entretien.

### 4.5 Technicien

-   **Interventions** : Tableau de bord principal affichant les interventions techniques qui vous sont assignées. Vous pouvez démarrer une intervention et, une fois terminée, soumettre un rapport détaillé.
-   **Historique** : Consultation de toutes vos interventions passées.
-   **Mes Tâches** : Liste des tâches de maintenance préventive ou autres tâches planifiées qui vous sont assignées.

### 4.6 Superviseur Technicien

Le Superviseur Technicien gère les activités de l'équipe technique.

-   **Dashboard Technique** : Vue d'ensemble des interventions techniques.
-   **Gestion Interventions** : Accès à la liste des interventions techniques, avec la possibilité de les assigner, de modifier leur priorité et leur statut.
-   **Planning Tâches** : Création et assignation de tâches planifiées spécifiquement pour les techniciens.
-   **Gestion Techniciens** : Gestion des comptes et des permissions des techniciens.

### 4.7 Médecin

-   **Mon Planning** : Accès au planning des salles. Les médecins peuvent voir leurs consultations et interagir avec elles.
    -   **Démarrer une consultation** : En cliquant sur une réservation, un bouton "Démarrer" apparaît. Il faut ensuite saisir un code PIN personnel pour valider le début de la consultation.
    -   **Terminer une consultation** : Une fois la consultation démarrée, le bouton se transforme en "Terminer". Cliquer dessus met fin à la réservation.

### 4.8 Secrétaire

-   **Planning des Salles** : Gestion complète du planning des salles de consultation et de réunion.
-   **Registre des Visiteurs** : Accès au registre pour enregistrer et suivre les visiteurs.

### 4.9 Superviseur QHSE

Le superviseur a une vue d'ensemble et des droits de gestion étendus.

-   **Dashboard QHSE** : Suivi de tous les tickets (sécurité, entretien, technique). Permet d'assigner un ticket à un agent, de définir sa priorité et de valider sa résolution.
-   **Planning des Tâches** : Création et assignation de tâches planifiées pour les agents (sécurité, entretien, techniciens).
-   **Personnel Médical** : Consultation de l'annuaire des médecins.
-   **Biomédical** : Gestion du parc d'équipements biomédicaux. Ajout de nouveaux équipements et planification des maintenances.
-   **Planning des Salles** : Vue complète du planning, avec la possibilité de créer, modifier et annuler des réservations.
-   **Paramètres (Gestion Utilisateurs)** : Création de nouveaux utilisateurs et gestion des permissions pour les agents et techniciens.

### 4.10 Superadmin

Le Superadmin dispose de tous les droits du Superviseur QHSE, avec des fonctionnalités supplémentaires.

-   **Dashboard Global** : Vue d'ensemble de toute l'activité de la clinique (incidents, utilisateurs, équipements, etc.).
-   **Gestion Utilisateurs (complète)** : Gestion de tous les comptes, y compris les superviseurs.
-   **Zone de Danger** : Possibilité de réinitialiser toutes les données de l'application à leur état initial (action irréversible).

## 5. Fonctionnalités Clés

### 5.1 Planning des Salles

Le planning des salles est un outil central pour l'organisation des consultations et réunions.

-   **Vues** : Vous pouvez basculer entre une vue "Matrice" (grille horaire) et une vue "Liste" (salle par salle).
-   **Création de Réservation** : Cliquez sur un créneau libre (en vert) dans la vue matrice ou sur le bouton "Réserver" pour ouvrir le formulaire de réservation.
-   **Alertes Visuelles** :
    -   Les réservations qui se terminent **dans les 5 prochaines minutes** sont surlignées en **jaune** et pulsent doucement pour attirer l'attention.
    -   Les réservations qui viennent de se terminer (dans les 15 dernières minutes) sont surlignées en **rouge** et clignotent pour signaler qu'un nettoyage est potentiellement requis.
-   **Gestion** : Les superviseurs et secrétaires peuvent modifier ou annuler une réservation en cliquant dessus.

### 5.2 Notifications

La cloche (🔔) en haut à droite vous alerte des événements importants liés à votre rôle (nouvelle tâche assignée, statut d'un ticket mis à jour, etc.). Un badge rouge indique le nombre de notifications non lues. Cliquez sur la cloche pour les consulter et les marquer comme lues.

---
*Fin du document.*